//FloorMountingPostGaps.scad;

include <UNO_Dimensions.scad>
use <UNO_FloorMountingPostGap.scad>;

//Use FloorMountingPostGap four times 
//to generate four mounting post gaps;

//FloorMountingPostGap generates one mounting 
//post gap centered at the origin 
//and the XY plane;
//It will extend FloorZ/2 below the XY plane 
//and FloorZ/2 above it;
//When translated by DeltaZ = FloorZ,
//it will make a gap Floor/2 into the top 
//of the floor;
    
//On exit from this module, 
//each gap is a small cylinder;
//It doesn't become a gap until it is used 
//as the second argument of a 
//difference() command;

//The gaps are all the same size;

module FloorMountingPostGaps()
{

echo("Begin FloorMountingPostGaps");
    
//DeltaZ is constant for all mounting posts;
DeltaZ = FloorZ;

//Four post holes for UNO;
echo("BL = ", PostUnoBLx, PostUnoBLy);
translate([PostUnoBLx, PostUnoBLy, DeltaZ])
    FloorMountingPostGap();

echo("BR = ", PostUnoBRx, PostUnoBRy);
translate([PostUnoBRx, PostUnoBRy, DeltaZ])
    FloorMountingPostGap();

echo("TR = ", PostUnoTRx, PostUnoTRy);
translate([PostUnoTRx, PostUnoTRy, DeltaZ])
    FloorMountingPostGap();

echo("TL = ", PostUnoTLx, PostUnoTLy);
translate([PostUnoTLx, PostUnoTLy, DeltaZ])
    FloorMountingPostGap();

}
//
